<?php
/**
 * Welcome Screen Class
 */
class stacy_screen {

	/**
	 * Constructor for the welcome screen
	 */
	public function __construct() {

		/* create dashbord page */
		add_action( 'admin_menu', array( $this, 'stacy_register_menu' ) );

		/* activation notice */
		add_action( 'load-themes.php', array( $this, 'stacy_activation_admin_notice' ) );

		/* enqueue script and style for welcome screen */
		add_action( 'admin_enqueue_scripts', array( $this, 'stacy_style_and_scripts' ) );

		/* enqueue script for customizer */
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'stacy_scripts_for_customizer' ) );

		/* load welcome screen */
		add_action( 'stacy_info_screen', array( $this, 'stacy_getting_started' ), 	    10 );
		//add_action( 'stacy_info_screen', array( $this, 'stacy_action_required' ), 	    20 );
		add_action( 'stacy_info_screen', array( $this, 'stacy_github' ), 		            40 );
		add_action( 'stacy_info_screen', array( $this, 'stacy_welcome_free_pro' ), 				50 );

		/* ajax callback for dismissable required actions */
		add_action( 'wp_ajax_stacy_dismiss_required_action', array( $this, 'stacy_dismiss_required_action_callback') );
		add_action( 'wp_ajax_nopriv_stacy_dismiss_required_action', array($this, 'stacy_dismiss_required_action_callback') );

	}

	public function stacy_register_menu() {
		add_theme_page( 'About Stacy Theme', 'About Stacy Theme', 'activate_plugins', 'stacy-info', array( $this, 'stacy_welcome_screen' ) );
	}

	public function stacy_activation_admin_notice() {
		global $pagenow;

		if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {
			add_action( 'admin_notices', array( $this, 'stacy_admin_notice' ), 99 );
		}
	}

	/**
	 * Display an admin notice linking to the welcome screen
	 * @sfunctionse 1.8.2.4
	 */
	public function stacy_admin_notice() {
		?>
			<div class="updated notice is-dismissible spicepress-notice">
				<h1><?php
				$theme_info = wp_get_theme();
				printf( esc_html__('Welcome to %1$s - Version %2$s', 'stacy'), esc_html( $theme_info->Name ), esc_html( $theme_info->Version ) ); ?>
				</h1>
				<p><?php echo sprintf( esc_html__("Welcome! Thank you for choosing SpiceThemes Stacy WordPress theme. To take full advantage of the features this theme has to offer visit our %swelcome page%s.", "stacy"), '<a href="' . esc_url( admin_url( 'themes.php?page=stacy-info' ) ) . '">', '</a>' ); ?></p>
				<p><a href="<?php echo esc_url( admin_url( 'themes.php?page=stacy-info' ) ); ?>" class="button button-blue-secondary button_stacy" style="text-decoration: none;"><?php _e('Get started with Stacy','stacy'); ?></a></p>
			</div>
		<?php
	}

	/**
	 * Load welcome screen css and javascript
	 * @sfunctionse  1.8.2.4
	 */
	public function stacy_style_and_scripts( $hook_suffix ) {

		if ( 'appearance_page_stacy-info' == $hook_suffix ) {
			
			
			wp_enqueue_style( 'stacy-info-css', get_stylesheet_directory_uri() . '/functions/stacy-info/css/bootstrap.css' );
			
			wp_enqueue_style( 'stacy-info-screen-css', get_stylesheet_directory_uri() . '/functions/stacy-info/css/welcome.css' );

			wp_enqueue_script( 'stacy-info-screen-js', get_stylesheet_directory_uri() . '/functions/stacy-info/js/welcome.js', array('jquery') );

			global $stacy_required_actions;

			$nr_actions_required = 0;

			/* get number of required actions */
			if( get_option('stacy_show_required_actions') ):
				$stacy_show_required_actions = get_option('stacy_show_required_actions');
			else:
				$stacy_show_required_actions = array();
			endif;

			if( !empty($stacy_required_actions) ):
				foreach( $stacy_required_actions as $stacy_required_action_value ):
					if(( !isset( $stacy_required_action_value['check'] ) || ( isset( $stacy_required_action_value['check'] ) && ( $stacy_required_action_value['check'] == false ) ) ) && ((isset($stacy_show_required_actions[$stacy_required_action_value['id']]) && ($stacy_show_required_actions[$stacy_required_action_value['id']] == true)) || !isset($stacy_show_required_actions[$stacy_required_action_value['id']]) )) :
						$nr_actions_required++;
					endif;
				endforeach;
			endif;

			wp_localize_script( 'stacy-info-screen-js', 'stacyLiteWelcomeScreenObject', array(
				'nr_actions_required' => $nr_actions_required,
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
				'template_directory' => get_stylesheet_directory_uri(),
				'no_required_actions_text' => __( 'Hooray! There are no required actions for you right now.','stacy' )
			) );
		}
	}

	/**
	 * Load scripts for customizer page
	 * @sfunctionse  1.8.2.4
	 */
	public function stacy_scripts_for_customizer() {

		wp_enqueue_style( 'stacy-info-screen-customizer-css', get_stylesheet_directory_uri() . '/functions/stacy-info/css/welcome_customizer.css' );
		wp_enqueue_script( 'stacy-info-screen-customizer-js', get_stylesheet_directory_uri() . '/functions/stacy-info/js/welcome_customizer.js', array('jquery'), '20120206', true );

		global $stacy_required_actions;

		$nr_actions_required = 0;

		/* get number of required actions */
		if( get_option('stacy_show_required_actions') ):
			$stacy_show_required_actions = get_option('stacy_show_required_actions');
		else:
			$stacy_show_required_actions = array();
		endif;

		if( !empty($stacy_required_actions) ):
			foreach( $stacy_required_actions as $stacy_required_action_value ):
				if(( !isset( $stacy_required_action_value['check'] ) || ( isset( $stacy_required_action_value['check'] ) && ( $stacy_required_action_value['check'] == false ) ) ) && ((isset($stacy_show_required_actions[$stacy_required_action_value['id']]) && ($stacy_show_required_actions[$stacy_required_action_value['id']] == true)) || !isset($stacy_show_required_actions[$stacy_required_action_value['id']]) )) :
					$nr_actions_required++;
				endif;
			endforeach;
		endif;

		wp_localize_script( 'stacy-info-screen-customizer-js', 'stacyLiteWelcomeScreenCustomizerObject', array(
			'nr_actions_required' => $nr_actions_required,
			'aboutpage' => esc_url( admin_url( 'themes.php?page=stacy-info' ) ),
			'customizerpage' => esc_url( admin_url( 'customize.php' ) ),
			'themeinfo' => __('View Theme Info','stacy'),
		) );
	}

	/**
	 * Dismiss required actions
	 * @sfunctionse 1.8.2.4
	 */
	public function stacy_dismiss_required_action_callback() {

		global $stacy_required_actions;

		$stacy_dismiss_id = (isset($_GET['dismiss_id'])) ? $_GET['dismiss_id'] : 0;

		echo $stacy_dismiss_id; /* this is needed and it's the id of the dismissable required action */

		if( !empty($stacy_dismiss_id) ):

			/* if the option exists, update the record for the specified id */
			if( get_option('stacy_show_required_actions') ):

				$stacy_show_required_actions = get_option('stacy_show_required_actions');

				$stacy_show_required_actions[$stacy_dismiss_id] = false;

				update_option( 'stacy_show_required_actions',$stacy_show_required_actions );

			/* create the new option,with false for the specified id */
			else:

				$stacy_show_required_actions_new = array();

				if( !empty($stacy_required_actions) ):

					foreach( $stacy_required_actions as $stacy_required_action ):

						if( $stacy_required_action['id'] == $stacy_dismiss_id ):
							$stacy_show_required_actions_new[$stacy_required_action['id']] = false;
						else:
							$stacy_show_required_actions_new[$stacy_required_action['id']] = true;
						endif;

					endforeach;

				update_option( 'stacy_show_required_actions', $stacy_show_required_actions_new );

				endif;

			endif;

		endif;

		die(); // this is required to return a proper result
	}


	/**
	 * Welcome screen content
	 * @sfunctionse 1.8.2.4
	 */
	public function stacy_welcome_screen() {

		require_once( ABSPATH . 'wp-load.php' );
		require_once( ABSPATH . 'wp-admin/admin.php' );
		require_once( ABSPATH . 'wp-admin/admin-header.php' );
		?>
		<div class="container-fluid">
		<div class="row">
		<div class="col-md-12">
		<ul class="stacy-nav-tabs" role="tablist">
			<li role="presentation" class="active"><a href="#getting_started" aria-controls="getting_started" role="tab" data-toggle="tab"><?php esc_html_e( 'Getting Started','stacy'); ?></a></li>
			
			<li role="presentation"><a href="#github" aria-controls="github" role="tab" data-toggle="tab"><?php esc_html_e( 'Why Upgrade to PRO?','stacy'); ?></a></li>
			<li role="presentation"><a href="#free_pro" aria-controls="free_pro" role="tab" data-toggle="tab"><?php esc_html_e( 'Free VS PRO','stacy'); ?></a></li>
			
		</ul>
		</div>
		</div>
		</div>

		<div class="stacy-tab-content">

			<?php do_action( 'stacy_info_screen' ); ?>

		</div>
		<?php
	}

	/**
	 * Getting started
	 *
	 */
	public function stacy_getting_started() {
		require_once( get_stylesheet_directory() . '/functions/stacy-info/sections/getting-started.php' );
	}

	/**
	 * Contribute
	 *
	 */
	public function stacy_github() {
		require_once( get_stylesheet_directory() . '/functions/stacy-info/sections/github.php' );
	}


	/**
	 * Free vs PRO
	 * 
	 */
	public function stacy_welcome_free_pro() {
		require_once( get_stylesheet_directory() . '/functions/stacy-info/sections/free_pro.php' );
	}
}

$GLOBALS['stacy_screen'] = new stacy_screen();