jQuery(document).ready(function() {

	/* If there are required actions, add an icon with the number of required actions in the About stacy page -> Actions required tab */
    var stacy_nr_actions_required = stacyLiteWelcomeScreenObject.nr_actions_required;

    if ( (typeof stacy_nr_actions_required !== 'undefined') && (stacy_nr_actions_required != '0') ) {
        jQuery('li.stacy-w-red-tab a').append('<span class="stacy-actions-count">' + stacy_nr_actions_required + '</span>');
    }

    /* Dismiss required actions */
    jQuery(".stacy-dismiss-required-action").click(function(){

        var id= jQuery(this).attr('id');
        console.log(id);
        jQuery.ajax({
            type       : "GET",
            data       : { action: 'stacy_dismiss_required_action',dismiss_id : id },
            dataType   : "html",
            url        : stacyLiteWelcomeScreenObject.ajaxurl,
            beforeSend : function(data,settings){
				jQuery('.stacy-tab-pane h1').append('<div id="temp_load" style="text-align:center"><img src="' + stacyLiteWelcomeScreenObject.template_directory + '/inc/stacy-info/img/ajax-loader.gif" /></div>');
            },
            success    : function(data){
				jQuery("#temp_load").remove(); /* Remove loading gif */
                jQuery('#'+ data).parent().remove(); /* Remove required action box */

                var stacy_lite_actions_count = jQuery('.stacy-actions-count').text(); /* Decrease or remove the counter for required actions */
                if( typeof stacy_lite_actions_count !== 'undefined' ) {
                    if( stacy_lite_actions_count == '1' ) {
                        jQuery('.stacy-actions-count').remove();
                        jQuery('.stacy-tab-pane').append('<p>' + stacyLiteWelcomeScreenObject.no_required_actions_text + '</p>');
                    }
                    else {
                        jQuery('.stacy-actions-count').text(parseInt(stacy_lite_actions_count) - 1);
                    }
                }
            },
            error     : function(jqXHR, textStatus, errorThrown) {
                console.log(jqXHR + " :: " + textStatus + " :: " + errorThrown);
            }
        });
    });

	/* Tabs in welcome page */
	function stacy_welcome_page_tabs(event) {
		jQuery(event).parent().addClass("active");
        jQuery(event).parent().siblings().removeClass("active");
        var tab = jQuery(event).attr("href");
        jQuery(".stacy-tab-pane").not(tab).css("display", "none");
        jQuery(tab).fadeIn();
	}

	var stacy_actions_anchor = location.hash;

	if( (typeof stacy_actions_anchor !== 'undefined') && (stacy_actions_anchor != '') ) {
		stacy_welcome_page_tabs('a[href="'+ stacy_actions_anchor +'"]');
	}

    jQuery(".stacy-nav-tabs a").click(function(event) {
        event.preventDefault();
		stacy_welcome_page_tabs(this);
    });

		/* Tab Content height matches admin menu height for scrolling purpouses */
	 $tab = jQuery('.stacy-tab-content > div');
	 $admin_menu_height = jQuery('#adminmenu').height();
	 if( (typeof $tab !== 'undefined') && (typeof $admin_menu_height !== 'undefined') )
	 {
		 $newheight = $admin_menu_height - 180;
		 $tab.css('min-height',$newheight);
	 }

});
